<?php

namespace App\Http\Controllers;

// use App\User;
use Illuminate\Http\Request;

class UserController extends Controller
{

  // public function data()
  // {
  //   // Setiap user akan memiliki banyak data
  //   return $this->hasMany('App\User','pemilik_id');
  // }

  public function __construct()
  {
      $this->middleware('auth');
  }

  /**
   * Show the application dashboard.
   *
   * @return \Illuminate\Contracts\Support\Renderable
   */
  public function index()
  {
    $perusahaan = DB::table('perusahaans')->get();
    // mengirim data perusahaan ke view index
    // $data = User::find($id);
    return view('index', ['perusahaan' => $perusahaan]);
  }


  public function perusahaans() {
        $client = new Client();

        $request = $client->get('localhost:8040/api/index');
        $response = $request->getBody();
        $perusahaan = json_decode($response, true);

        return view('indexPerusahaan', ['perusahaans' => $perusahaan]);
    }

    public function view($id) {
        $client = new Client();

        $request = $client->get('localhost:8040/api/view/' . $id);
        $response = $request->getBody();
        $perusahaan = json_decode($response);

        $request = $client->get('localhost:8060/api/index/' . $id);
        $response = $request->getBody();
        $komentar = json_decode($response);

        return view('komenPerusahaan', ['perusahaans' => $perusahaan, 'comments' => $komentar]);
    }

    public function addPerusahaan() {
        return view('addPerusahaan');
    }

    public function addPerusahaanProses(Request $request) {
        $client = new Client();
        $data['nama_perusahaan'] = $request->name;
        $data['email_perusahaan'] = $request->email;
        $data['kategori'] = $request->kategori;
        $data['deskripsi'] = $request->deskripsi;
        $client->post('localhost:8040/api/add/',
            ['form_params' => $data]);
        return redirect('/perusahaan');
    }

    public function updatePerusahaan($id) {
        $client = new Client();

        $request = $client->get('localhost:8000/api/view/' . $id);
        $response = $request->getBody();
        $perusahaan = json_decode($response);

        return view('perusahaan', ['perusahaans' => $perusahaan]);
    }

    public function updatePerusahaanProcess(Request $request, $id) {
        $client = new Client();
        $data['nama_perusahaan'] = $request->name;
        $data['email_perusahaan'] = $request->email;
        $data['kategori'] = $request->kategori;
        $data['deskripsi'] = $request->deskripsi;
        $client->put('localhost:8060/api/update/' . $id,
            ['form_params' => $data]);
        return redirect('/perusahaan');
    }

    public function deletePerusahaan($id) {
        $client = new Client();
        $client->delete('localhost:8000/api/delete/' . $id);

        return redirect()->back();
    }

    public function addKomentar(Request $request, $komentar) {
        $client = new Client();
        $data['body'] = $request->body;
        $client->post('localhost:8060/api/create/',
            ['form_params' => $data]);
        return redirect()->back();
    }
}
